<?php
/**
* Classe para enviar, receber e pesquisar SMS no papo Webservice
*
* https://www.paposms.com/webservice/1.0/
*/

class PapoSMS
{
    private $webservice = 'https://www.paposms.com/webservice/1.0/';
    private $user = '';
    private $pass = '';
    private $numbers = '';
    private $message = '';
    private $date = '';
    private $ids = '';
    private $data_start = '';
    private $data_end = '';
    private $lido = '';
    private $status = '';
    private $entregue = '';
    private $data_confirmacao = '';
    private $return_format = '';
    private $fields = array();

    public function __construct($user = '', $pass = '', $numbers = '', $message = '')
    {
        $this->setUser($user);
        $this->setPass($pass);
        $this->setNumbers($numbers);
        $this->setMessage($message);
    }

    public function setUser($value)
    {
        $this->user = $value;
    }

    public function setPass($value)
    {
        $this->pass = $value;
    }

    public function setNumbers($value)
    {
        $this->numbers = preg_replace("/[^0-9;]/", "", $value);
    }

    public function setMessage($value)
    {
        if ($value !== '')  {
            $value = substr($value, 0, 160);
        }
        $this->message = $value;
    }

    public function setDate($value)
    {
        $this->date = $value;
    }

    public function setIds($value)
    {
        $this->ids = $value;
    }

    public function setDataStart($value)
    {
        $this->data_start = $value;
    }

    public function setDataEnd($value)
    {
        $this->data_end = $value;
    }

    public function setLido($value)
    {
        $this->lido = $value;
    }

    public function setStatus($value)
    {
        $this->status = $value;
    }

    public function setEntregue($value)
    {
        $this->entregue = $value;
    }

    public function setDataConfirmacao($value)
    {
        $this->data_confirmacao = $value;
    }

    public function setReturnFormat($value)
    {
        $this->return_format = $value;
    }

    public function send()
    {
        $url = $this->webservice.'send/';

        // Dados para o SMS
        $fields = $this->checkFields();

        // Organizar dados para URL
        $postvars = http_build_query($fields);

        // Pedido de envio de SMS ao WebService
        $result = file_get_contents($url."?".$postvars);

        return $result;
    }

    public function receive()
    {
        $url = $this->webservice.'get/';

        // Dados para o SMS
        $fields = $this->checkFields();

        // Organizar dados para URL
        $postvars = http_build_query($fields);

        // Pedido de dados ao WebService
        $result = file_get_contents($url."?".$postvars);

        return $result;
    }

    public function search()
    {
        $url = $this->webservice.'search/';

        // Dados para o SMS
        $fields = $this->checkFields();

        // Organizar dados para URL
        $postvars = http_build_query($fields);

        // Pedido de dados ao WebService
        $result = file_get_contents($url."?".$postvars);

        return $result;
    }

    public function getSaldo()
    {
        $url = $this->webservice.'saldo/';

        // Dados para consulta do Saldo
        $fields = $this->checkFields();

        // Organizar dados para URL
        $postvars = http_build_query($fields);

        // Pedido de dados ao WebService
        $result = file_get_contents($url."?".$postvars);

        return $result;
    }

    private function checkFields()
    {
        // Apenas usa parametros com valor, senao gera erro
        $vars = array('user', 'pass', 'numbers', 'message', 'date', 'ids', 'data_start', 'data_end',
                        'lido', 'status', 'entregue', 'data_confirmacao', 'return_format'
                    );

        $final = array();
        foreach ($vars as $key => $value) {
            if ($this->$value !== '') {
                $final[$value] = $this->$value;
            }
        }
        return $final;
    }
}

// Exemplo de uso
$sms = new PapoSMS('user', 'pass', '4100000000', 'Mensagem!!');

// Definir o retorno como formato JSON
$sms->setReturnFormat('json');

// Enviar mensagem
$result = $sms->send();

$result_array = json_decode($result, true);

if ($result_array['result'] === true) {
    echo "Mensagem enviada.";
} else {
    echo "Mensagem não enviada";
}


// Receber todas as mensagens nao lidas
$sms->setNumbers('');
$sms->setMessage('');
$sms->setLido('nao');
$result = $sms->receive();

$result_array = json_decode($result, true);

if (array_key_exists('error', $result_array)) {
    echo "ERRO: ".$result_array['label'];
} else {
    echo "Mensagens:<br><br>";
    foreach ($result_array['mensagens'] as $key => $value) {
        echo "Mensagem #".$key."<br>Data de rebebimento: ".$value['data_recebimento']."<br>".$value['mensagem']."<br><br>";
    }
}


// Mostrar todas as mensagens que foram enviadas nos último 5 dias com indicacao de nao entregue
$date_start = date("Y-m-d", strtotime("-5 days"));
$date_end = date("Y-m-d");
$sms->setLido('');
$sms->setStatus('3');
$sms->setDataStart($date_start);
$sms->setDataEnd($date_end);
$sms->setEntregue('0');
$result = $sms->search();

$result_array = json_decode($result, true);

if (array_key_exists('error', $result_array)) {
    echo "ERRO: ".$result_array['label'];
} else {
    echo "Mensagens:<br><br>";
    foreach ($result_array['mensagens'] as $key => $value) {
        echo "Mensagem #".$key."<br>".$value['mensagem']."<br><br>";
    }
}




// Exemplo de uso Consulta do Saldo
$sms = new PapoSMS('user', 'pass');

// Definir o retorno como formato JSON
$sms->setReturnFormat('json');

// Consulta o Saldo
$result = $sms->getSaldo();

$result_array = json_decode($result, true);

if ($result_array['result'] === true) {
    echo "ERRO: ".$result_array['label'];
} else {
    echo "Saldo: ".$result_array['valores']['saldo']."<br>";
    echo "Agendados: ".$result_array['valores']['agendados']."<br>";
    echo "Enviados: ".$$result_array['valores']['enviados']."<br>";
    echo "Recebidos: ".$result_array['valores']['recebidos']."<br>";
    echo "Falhas: ".$result_array['valores']['falhas']."<br>";
}
